import type { RepomixConfigMerged } from '../config/configSchema.js';
import type { RepomixProgressCallback } from '../shared/types.js';
import type { SuspiciousFileResult } from './security/securityCheck.js';
export interface PackResult {
    totalFiles: number;
    totalCharacters: number;
    totalTokens: number;
    fileCharCounts: Record<string, number>;
    fileTokenCounts: Record<string, number>;
    suspiciousFilesResults: SuspiciousFileResult[];
}
export declare const pack: (rootDir: string, config: RepomixConfigMerged, progressCallback?: RepomixProgressCallback, deps?: {
    searchFiles: (rootDir: string, config: RepomixConfigMerged) => Promise<import("./file/fileSearch.js").FileSearchResult>;
    collectFiles: (filePaths: string[], rootDir: string) => Promise<import("./file/fileTypes.js").RawFile[]>;
    processFiles: (rawFiles: import("./file/fileTypes.js").RawFile[], config: RepomixConfigMerged, progressCallback: RepomixProgressCallback) => Promise<import("./file/fileTypes.js").ProcessedFile[]>;
    generateOutput: (rootDir: string, config: RepomixConfigMerged, processedFiles: import("./file/fileTypes.js").ProcessedFile[], allFilePaths: string[]) => Promise<string>;
    validateFileSafety: (rawFiles: import("./file/fileTypes.js").RawFile[], progressCallback: RepomixProgressCallback, config: RepomixConfigMerged, deps?: {
        runSecurityCheckIfEnabled: (rawFiles: import("./file/fileTypes.js").RawFile[], config: RepomixConfigMerged, progressCallback: RepomixProgressCallback, deps?: {
            runSecurityCheck: (rawFiles: import("./file/fileTypes.js").RawFile[], progressCallback?: RepomixProgressCallback) => Promise<SuspiciousFileResult[]>;
        }) => Promise<SuspiciousFileResult[]>;
        filterOutUntrustedFiles: (rawFiles: import("./file/fileTypes.js").RawFile[], suspiciousFilesResults: SuspiciousFileResult[]) => import("./file/fileTypes.js").RawFile[];
    }) => Promise<{
        safeRawFiles: import("./file/fileTypes.js").RawFile[];
        safeFilePaths: string[];
        suspiciousFilesResults: SuspiciousFileResult[];
    }>;
    writeOutputToDisk: (output: string, config: RepomixConfigMerged) => Promise<undefined>;
    copyToClipboardIfEnabled: (output: string, progressCallback: RepomixProgressCallback, config: RepomixConfigMerged) => Promise<undefined>;
    calculateMetrics: (processedFiles: import("./file/fileTypes.js").ProcessedFile[], output: string, progressCallback: RepomixProgressCallback, config: RepomixConfigMerged) => Promise<import("./metrics/calculateMetrics.js").CalculateMetricsResult>;
}) => Promise<PackResult>;
//# sourceMappingURL=packager.d.ts.map